// DE_13 I2C - IO Port 8574AT und 8574T

#include <Wire.h> // Definitionen laden fuer I2C
#include <avr/pgmspace.h> // weitere Definitionen

// Alle Adressen bei den 8574xx bricks:
#define i2cIO8574_0 (0x40>>1) // Trick um elegant mit Bytes
#define i2cIO8574_1 (0x42>>1) // zu arbeiten statt in 7 Bit
#define i2cIO8574_2 (0x44>>1) // das letzte Bit ist das R/W
#define i2cIO8574_3 (0x46>>1) // dass von der Arduino
#define i2cIO8574_4 (0x48>>1) // Bibliothek dazugefuegt wird
#define i2cIO8574_5 (0x4A>>1) // wir definieren hier alle 
#define i2cIO8574_6 (0x4C>>1) // Bereiche die man mit den 
#define i2cIO8574_7 (0x4E>>1) // Bricks einstellen kann,.

#define i2cIO8574A_0 (0x70>>1) // Die Serie PCF8474AT
#define i2cIO8574A_1 (0x72>>1) // beginnt bei Adresse
#define i2cIO8574A_2 (0x74>>1) // 0x70 = 70 sedezimal
#define i2cIO8574A_3 (0x76>>1)  // 01110000 binaer
#define i2cIO8574A_4 (0x78>>1) // oder intern 0111000
#define i2cIO8574A_5 (0x7A>>1) // dabei 0111xxx
#define i2cIO8574A_6 (0x7C>>1) // mit x fuer die 
#define i2cIO8574A_7 (0x7E>>1) // Dilschalterposition

// ACHTUNG: hier Zuordnung setzen je nach Schalterstellung

#define myi2cIOadr i2cIO8574A_0 // HIER PASSENDE ADRESSE EINTRAGEN

void setup() {
  Wire.begin(); // I2C aktivieren ! 
}

void loop() {
  Wire.beginTransmission(myi2cIOadr);// Startvorgang I2C Adresse
  Wire.write(0x55) ; // IO Ports auf 01010101 abwechseln
  Wire.endTransmission(); // Stop Kondition setzen bei I2C
  delay(100); // 100 ms verzoegern.
  Wire.beginTransmission(myi2cIOadr); // Nochmal die Adresse
  Wire.write(0xaa) ; // IO Ports auf 10101010 im Wechsel
  Wire.endTransmission(); // Stop Kondition setzen
  delay(100); // 100 ms verzoegern.
}
