// DE_14 I2C - IO Port 8574AT und 8574T Lowpulse

#include <Wire.h>
#include <avr/pgmspace.h>

#define i2cIO8574_0 (0x40>>1) // Trick um elegant mit Bytes
#define i2cIO8574_1 (0x42>>1) // zu arbeiten statt in 7 Bit
#define i2cIO8574_2 (0x44>>1) // das letzte Bit ist das R/W
#define i2cIO8574_3 (0x46>>1) // dass von der Arduino
#define i2cIO8574_4 (0x48>>1) // Bibliothek dazugefuegt wird
#define i2cIO8574_5 (0x4A>>1) // wir definieren hier alle 
#define i2cIO8574_6 (0x4C>>1) // Bereiche die man mit den 
#define i2cIO8574_7 (0x4E>>1) // Bricks einstellen kann,.

#define i2cIO8574A_0 (0x70>>1) // Die Serie PCF8474AT
#define i2cIO8574A_1 (0x72>>1) // beginnt bei Adresse
#define i2cIO8574A_2 (0x74>>1) // 0x70 = 70 sedezimal
#define i2cIO8574A_3 (0x76>>1) // 01110000 binaer
#define i2cIO8574A_4 (0x78>>1) // oder intern 0111000
#define i2cIO8574A_5 (0x7A>>1) // dabei 0111xxx
#define i2cIO8574A_6 (0x7C>>1) // mit x fuer die 
#define i2cIO8574A_7 (0x7E>>1) // Dilschalterposition

// ACHTUNG: hier Zuordnung setzen je nach Schalterstellung

// ACHTUNG: hier Zuordnung setzen je nach DILSCHALTER !

#define myi2cIOadr i2cIO8574A_0 // wir nehmen den 0x70

#define PULLUP2 2 // Kleiner Trick am Port 2 und 3
#define PULLUP3 3 // bekommen wir 5V (40mA maximal!)

void setup() {
  pinMode(PULLUP2, OUTPUT); // PD2 und PD3 brauchen wir als Ausgang
  pinMode(PULLUP3, OUTPUT); // muss man dann noch auf High stellen
  digitalWrite(PULLUP2,HIGH); // damit sie beide 5V liefern
  digitalWrite(PULLUP3,HIGH); // schnell schnell, da sonst Kurzschluss
  Wire.begin(); // I2C aktiviern
}

void loop() {
  Wire.beginTransmission(myi2cIOadr); // Dann wie gehabt starten
  Wire.write(0x55) ; // IO Ports auf 01010101 abwechseln
  Wire.endTransmission(); // Ende 
  delay(100); // 10ms Verzoegerung
  Wire.beginTransmission(myi2cIOadr); // ncohmal starten
  Wire.write(0xaa) ; // IO Ports auf 10101010 im Wechsel
  Wire.endTransmission(); // und wieder Stopbit
  delay(100); // nochmal 100ms Warten fuer Blinkeffekt
}
