// DE_17 Tasten koennen Prellen
#include <Wire.h>

// 8574T
#define i2cseg7x2alsb1 (0x40>>1)
#define i2cseg7x2amsb1 (0x42>>1)
#define i2cseg7x2blsb1 (0x44>>1)
#define i2cseg7x2bmsb1 (0x46>>1)
#define i2cseg7x2clsb1 (0x48>>1)
#define i2cseg7x2cmsb1 (0x4A>>1)
#define i2cseg7x2dlsb1 (0x4C>>1)
#define i2cseg7x2dmsb1 (0x4E>>1)

// 8574AT optional
#define i2cseg7x2alsb2 (0x70>>1)
#define i2cseg7x2amsb2 (0x72>>1)
#define i2cseg7x2blsb2 (0x74>>1)
#define i2cseg7x2bmsb2 (0x76>>1)
#define i2cseg7x2clsb2 (0x78>>1)
#define i2cseg7x2cmsb2 (0x7A>>1)
#define i2cseg7x2dlsb2 (0x7C>>1)
#define i2cseg7x2dmsb2 (0x7E>>1)


// *************************
//          01
//       20    02
//          40
//       10    04
//          08
//                 80
// ************************

// UMrechnungstabelle ASCI -> 7 Segment

// OFFSET code 32..5F
const unsigned char siebensegtable[] =
{
   0, // 20 Space
   0x30, // 21 !
   0x22, // 22 "
   0x7f, // 23 #
   0, // 24 $
   0, // 25 %
   0, // 26 &
   0x02, // 27 '
   0x39, // 28 (
   0x0f, // 29 )
   0, // 2A *
   0x7f, // 2B +
   0x04, // 2C ,
   0x40, // 2D -
   0x80, // 2E .
   0x30, // 2F /
   0x3f, // 30 0
   0x06, // 31 1
   0x5b, // 32 2
   0x4f, // 33 3
   0x66, // 34 4
   0x6d, // 35 5
   0x7c, // 36 6
   0x07, // 37 7
   0x7f, // 38 8
   0x67, // 39 9
   //
   0, // 3A :
   0, // 3B ;
   0, // 3C <
   0x48, // 3D =
   0, // 3E >
   0, // 3F ?
   0x5c, // 40 @
   0x77, // 41 A
   0x7c, // 42 B
   0x39, // 43 C
   0x5e, // 44 D
   0x79, // 45 E
   0x71, // 46 F
   0x67, // 47 G
   0x76, // 48 H
   0x06, // 49 I
   0x86, // 4A J
   0x74, // 4B K
   0x38, // 4C L
   0x37, // 4D M
   0x54, // 4E N
   0x5c, // 4F O
   0x73, // 50 P
   0xbf, // 51 Q
   0x50, // 52 R
   0x6d, // 53 S
   0x70, // 54 T
   0x3e, // 55 U
   0x1c, // 56 V
   0x9c, // 57 W
   0x24, // 58 X
   0x36, // 59 Y
   0x5b, // 5A Z
   0x39, // 5B [
   0x30, // 5C
   0x0f, // 5D ]
   0x08, // 5E _
   0 // 5F
};

//
unsigned int get_7seg(unsigned char asciicode)
{
    // Umrechnen 0..255 auf
    // 7seg
    // Dabei nur Zahlen und Grossbuchstaben
    // 20..5F
    // rest wird gemappt
    asciicode = asciicode & 0x7f; // 7 bit only
    if (asciicode < 0x20) return (0);
    if (asciicode >= 0x60) asciicode = asciicode - 0x20;
    return((~siebensegtable[asciicode-0x20])&0xff);
}

void display_seg1x(unsigned char i2cbaseadr, unsigned char ch1)
{
  Wire.beginTransmission(i2cbaseadr);
  Wire.write(get_7seg(ch1));
  Wire.endTransmission();
}

void display_seg1xbin(unsigned char i2cbaseadr, unsigned char ch1)
{ 
  Wire.beginTransmission(i2cbaseadr);
  Wire.write(ch1);
  Wire.endTransmission();
}



// Code neu:
#define PORTTASTE 2 // hier an PD2 die Taste anschliessen

// I2C initialisieren und Taste definieren
void setup() {
  Wire.begin(); // I2C
  pinMode(PORTTASTE,INPUT_PULLUP); // Taste mit Pullup
}

void loop() { // Schleife beginnt hier
  char buffer[10]; // Dort komtm Zaehlerstand in ASCII
  static int counter = 0; // Der Testcounter
  sprintf(buffer,"%02d",counter); // Umwandlen in ASCII
  // Taste abfragen, kann prellen
  if (digitalRead(PORTTASTE)==LOW) { // wenn auf 0 geht
    while (digitalRead(PORTTASTE)==LOW) { // Solange gedrueckt
     // warten bis losgelassen !
    } // Sonst gehts gar nicht
    counter++; // dann erst zaehlen - aber auch Prellen wird gezaehlt
  }
  if (counter > 99) counter = 0; // wie vorher 0..9 zaehlern dann von vorne
   // Counter ausgeben
  display_seg1x(i2cseg7x2amsb1,buffer[0]); // msb zeichen
  display_seg1x(i2cseg7x2alsb1,buffer[1]); // lsb zeichen
} // Ende der Schleife
