// DE_33 DA Beispiele Da Brick I2Cs

#include <Wire.h>
#include <avr/pgmspace.h>

// 1E=GND,1c=Open,1a=VCC AD5622  JUmper offen dann 1Ch
// 0001 1aa0
// aber nur aa=01 10 11 sind  moegliche Adressen

#define i2cdasel1 (0x1a>>1)  // ADRESSE Einstellen 1a,1c,1e 
#define i2cdasel2 (0x1c>>1)  // ADRESSE Einstellen 1a,1c,1e 
#define i2cdasel3 (0x1e>>1)  // ADRESSE Einstellen 1a,1c,1e 


void i2c_da_write_command(unsigned char i2cbaseadr, unsigned short cmdvalue)
{
  // BIt15,14=0 13,12=pd (std=0) dann 11..0 = DA Value
  cmdvalue = cmdvalue & 0xFFF; // 12 Bits valide // 0..4095 Wertebereich
  Wire.beginTransmission(i2cbaseadr); // I2C Start senden
  Wire.write((cmdvalue>>8)&0xff); //  dann MSB zuerst 
  Wire.write(cmdvalue&0xff);  // danach das LSB
  Wire.endTransmission(); // I2C beenden
}

void setup() {
  Wire.begin(); // i2C Initialisierung
}

void loop() {
  static int daval=0; // Wert statisch fuer tests wird hochgezaehlt
  // Alle moeglichen I2C Adresse ausgeben der Einfachheit halber
  i2c_da_write_command(i2cdasel1,daval); // Hier mal alle DA Umsetzer
  i2c_da_write_command(i2cdasel2,daval); // an sprechen die moeglich sind
  i2c_da_write_command(i2cdasel3,daval); // Nur einer wird aber verwendet
  delay(1); // 1ms nur zur Sicherheit damit nicht zu schnell und alles noch sichtbar
  daval++; // Neuer DA Wert
  if (daval>4095) daval = 0; // Ueberlauf verhindern 0..4095 
}
