// DE_34 DA Beispiele Da Brick I2Cs und Poti

#include <Wire.h>
#include <avr/pgmspace.h>

// 1E=GND,1c=Open,1a=VCC AD5622  JUmper offen dann 1Ch
// 0001 1aa0
// aber nur aa=01 10 11 sind  moegliche Adressen

#define i2cdasel1 (0x1a>>1)  // ADRESSE Einstellen 1a,1c,1e 
#define i2cdasel2 (0x1c>>1)  // ADRESSE Einstellen 1a,1c,1e 
#define i2cdasel3 (0x1e>>1)  // ADRESSE Einstellen 1a,1c,1e 


void i2c_da_write_command(unsigned char i2cbaseadr, unsigned short cmdvalue)
{
  // BIt15,14=0 13,12=pd (std=0) dann 11..0 = DA Value
  cmdvalue = cmdvalue & 0xFFF; // 12 Bits valide // 0..4095 Wertebereich
  Wire.beginTransmission(i2cbaseadr); // I2C Start senden
  Wire.write((cmdvalue>>8)&0xff); //  dann MSB zuerst 
  Wire.write(cmdvalue&0xff);  // danach das LSB
  Wire.endTransmission(); // I2C beenden
}

void setup() {
  Wire.begin(); // i2C Initialisieren
}

void loop() {
  int daval=0; // Als Zwischenvariable verwendet
  int poti = analogRead(A0); // a1,a2,a3 kann man austauschen
  daval = poti << 2; // 0..1023 -> 0..4095  UMRECHNUNG
  // Alle moeglichen I2C Adresse ausgeben der Einfachheit halber
  i2c_da_write_command(i2cdasel1,daval); // Hier mal alle DA Umsetzer
  i2c_da_write_command(i2cdasel2,daval); // an sprechen die moeglich sind
  i2c_da_write_command(i2cdasel3,daval); // Nur einer wird aber verwendet
}
