// DE_38 Anwendungen - Einfache Diodenkennlinie

#include <Wire.h>
#include <avr/pgmspace.h>

// Hier ggf Adresse anpassen 78 oder 7A je nach Schalter
#define i2coledssd (0x7A>>1)  // default ist 7A 

// -------------------------OLED ----------------------------------------------
// GLO066-D-M2005 -- SSD 1306 driver
// 011110sr  s=sa r=rw bei ssd1306 sa = adressbit optional zu setzen
// 0x78
// 0x78 und 0x7A je nach schalter...



//
// *****************************************************************
// RDK 2014 FONT Sets
//

/*******************************************************************************
*                                                                             *
* This file is generated by BitFontCreator Pro v3.0                           *
* by Iseatech Software   http://www.iseasoft.com/bfc.htm                      *
*                        support@iseatech.com                                 *
*                                                                             *
* Font name: Arial                                                            *
* Font width: 0 (proportional font)                                           *
* Font height: 27                                                             *
* Encode: Unicode                                                             *
*                                                                             *
* Data length: 8 bits                                                         *
* Invert bits: No                                                             *
* Data format: Big Endian, Row based, Row preferred, Unpacked                 *
*                                                                             *
* Create time: 13:31 12-01-2011                                               *
*******************************************************************************/
const unsigned char fontArial14h_data_tablep[] PROGMEM =
{
 
/* character 0x0020 (' '): [width=3, offset= 0x0000 (0) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x0021 ('!'): [width=2, offset= 0x000E (14) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x00, 0x80, 0x00, 0x00, 0x00,

/* character 0x0022 ('"'): [width=4, offset= 0x001C (28) ] */
  0x00, 0x00, 0x00, 0xA0, 0xA0, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x0023 ('#'): [width=6, offset= 0x002A (42) ] */
  0x00, 0x00, 0x00, 0x28, 0x28, 0xF8, 0x50, 0x50,
  0xF8, 0xA0, 0xA0, 0x00, 0x00, 0x00,

/* character 0x0024 ('$'): [width=6, offset= 0x0038 (56) ] */
  0x00, 0x00, 0x00, 0x70, 0xA8, 0xA0, 0x70, 0x28,
  0x28, 0xA8, 0x70, 0x20, 0x00, 0x00,

/* character 0x0025 ('%'): [width=10, offset= 0x0046 (70) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x00,
  0x94, 0x00, 0x94, 0x00, 0x68, 0x00, 0x0B, 0x00,
  0x14, 0x80, 0x14, 0x80, 0x23, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,

/* character 0x0026 ('&'): [width=7, offset= 0x0062 (98) ] */
  0x00, 0x00, 0x00, 0x30, 0x48, 0x48, 0x30, 0x50,
  0x8C, 0x88, 0x74, 0x00, 0x00, 0x00,

/* character 0x0027 ('''): [width=2, offset= 0x0070 (112) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x0028 ('('): [width=4, offset= 0x007E (126) ] */
  0x00, 0x00, 0x00, 0x20, 0x40, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x40, 0x20, 0x00,

/* character 0x0029 (')'): [width=4, offset= 0x008C (140) ] */
  0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x40, 0x80, 0x00,

/* character 0x002A ('*'): [width=4, offset= 0x009A (154) ] */
  0x00, 0x00, 0x00, 0x40, 0xE0, 0x40, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x002B ('+'): [width=6, offset= 0x00A8 (168) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xF8,
  0x20, 0x20, 0x00, 0x00, 0x00, 0x00,

/* character 0x002C (','): [width=3, offset= 0x00B6 (182) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x40, 0x40, 0x00,

/* character 0x002D ('-'): [width=4, offset= 0x00C4 (196) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x002E ('.'): [width=3, offset= 0x00D2 (210) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x00, 0x00, 0x00,

/* character 0x002F ('/'): [width=3, offset= 0x00E0 (224) ] */
  0x00, 0x00, 0x00, 0x20, 0x20, 0x40, 0x40, 0x40,
  0x40, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x0030 ('0'): [width=6, offset= 0x00EE (238) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88,
  0x88, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0031 ('1'): [width=6, offset= 0x00FC (252) ] */
  0x00, 0x00, 0x00, 0x20, 0x60, 0xA0, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x00, 0x00, 0x00,

/* character 0x0032 ('2'): [width=6, offset= 0x010A (266) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0x08, 0x10,
  0x20, 0x40, 0xF8, 0x00, 0x00, 0x00,

/* character 0x0033 ('3'): [width=6, offset= 0x0118 (280) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0x30, 0x08,
  0x08, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0034 ('4'): [width=6, offset= 0x0126 (294) ] */
  0x00, 0x00, 0x00, 0x10, 0x30, 0x50, 0x50, 0x90,
  0xF8, 0x10, 0x10, 0x00, 0x00, 0x00,

/* character 0x0035 ('5'): [width=6, offset= 0x0134 (308) ] */
  0x00, 0x00, 0x00, 0x78, 0x40, 0x80, 0xF0, 0x08,
  0x08, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0036 ('6'): [width=6, offset= 0x0142 (322) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x80, 0xF0, 0x88,
  0x88, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0037 ('7'): [width=6, offset= 0x0150 (336) ] */
  0x00, 0x00, 0x00, 0xF8, 0x10, 0x10, 0x20, 0x20,
  0x40, 0x40, 0x40, 0x00, 0x00, 0x00,

/* character 0x0038 ('8'): [width=6, offset= 0x015E (350) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x70, 0x88,
  0x88, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0039 ('9'): [width=6, offset= 0x016C (364) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x78,
  0x08, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x003A (':'): [width=3, offset= 0x017A (378) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00,

/* character 0x003B (';'): [width=3, offset= 0x0188 (392) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x80, 0x00,

/* character 0x003C ('<'): [width=6, offset= 0x0196 (406) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x70, 0x80,
  0x70, 0x08, 0x00, 0x00, 0x00, 0x00,

/* character 0x003D ('='): [width=6, offset= 0x01A4 (420) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x003E ('>'): [width=6, offset= 0x01B2 (434) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x70, 0x08,
  0x70, 0x80, 0x00, 0x00, 0x00, 0x00,

/* character 0x003F ('?'): [width=6, offset= 0x01C0 (448) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0x10, 0x20,
  0x20, 0x00, 0x20, 0x00, 0x00, 0x00,

/* character 0x0040 ('@'): [width=11, offset= 0x01CE (462) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00,
  0x60, 0x80, 0x4D, 0x40, 0x93, 0x40, 0xA2, 0x40,
  0xA2, 0x40, 0xA6, 0x80, 0x9B, 0x00, 0x40, 0x40,
  0x3F, 0x80, 0x00, 0x00,

/* character 0x0041 ('A'): [width=8, offset= 0x01EA (490) ] */
  0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x28, 0x44,
  0x7C, 0x82, 0x82, 0x00, 0x00, 0x00,

/* character 0x0042 ('B'): [width=7, offset= 0x01F8 (504) ] */
  0x00, 0x00, 0x00, 0xF8, 0x84, 0x84, 0xFC, 0x84,
  0x84, 0x84, 0xF8, 0x00, 0x00, 0x00,

/* character 0x0043 ('C'): [width=7, offset= 0x0206 (518) ] */
  0x00, 0x00, 0x00, 0x38, 0x44, 0x80, 0x80, 0x80,
  0x80, 0x44, 0x38, 0x00, 0x00, 0x00,

/* character 0x0044 ('D'): [width=7, offset= 0x0214 (532) ] */
  0x00, 0x00, 0x00, 0xF0, 0x88, 0x84, 0x84, 0x84,
  0x84, 0x88, 0xF0, 0x00, 0x00, 0x00,

/* character 0x0045 ('E'): [width=6, offset= 0x0222 (546) ] */
  0x00, 0x00, 0x00, 0xF8, 0x80, 0x80, 0xF8, 0x80,
  0x80, 0x80, 0xF8, 0x00, 0x00, 0x00,

/* character 0x0046 ('F'): [width=6, offset= 0x0230 (560) ] */
  0x00, 0x00, 0x00, 0xF8, 0x80, 0x80, 0xF0, 0x80,
  0x80, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x0047 ('G'): [width=8, offset= 0x023E (574) ] */
  0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x80, 0x8E,
  0x82, 0x44, 0x38, 0x00, 0x00, 0x00,

/* character 0x0048 ('H'): [width=7, offset= 0x024C (588) ] */
  0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0xFC, 0x84,
  0x84, 0x84, 0x84, 0x00, 0x00, 0x00,

/* character 0x0049 ('I'): [width=2, offset= 0x025A (602) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x004A ('J'): [width=5, offset= 0x0268 (616) ] */
  0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x90, 0x90, 0x60, 0x00, 0x00, 0x00,

/* character 0x004B ('K'): [width=7, offset= 0x0276 (630) ] */
  0x00, 0x00, 0x00, 0x84, 0x88, 0x90, 0xB0, 0xD0,
  0x88, 0x88, 0x84, 0x00, 0x00, 0x00,

/* character 0x004C ('L'): [width=6, offset= 0x0284 (644) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0xF8, 0x00, 0x00, 0x00,

/* character 0x004D ('M'): [width=8, offset= 0x0292 (658) ] */
  0x00, 0x00, 0x00, 0x82, 0xC6, 0xC6, 0xAA, 0xAA,
  0xAA, 0x92, 0x92, 0x00, 0x00, 0x00,

/* character 0x004E ('N'): [width=7, offset= 0x02A0 (672) ] */
  0x00, 0x00, 0x00, 0x84, 0xC4, 0xA4, 0xA4, 0x94,
  0x94, 0x8C, 0x84, 0x00, 0x00, 0x00,

/* character 0x004F ('O'): [width=8, offset= 0x02AE (686) ] */
  0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82,
  0x82, 0x44, 0x38, 0x00, 0x00, 0x00,

/* character 0x0050 ('P'): [width=6, offset= 0x02BC (700) ] */
  0x00, 0x00, 0x00, 0xF0, 0x88, 0x88, 0x88, 0xF0,
  0x80, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x0051 ('Q'): [width=8, offset= 0x02CA (714) ] */
  0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82,
  0x9A, 0x44, 0x3A, 0x00, 0x00, 0x00,

/* character 0x0052 ('R'): [width=7, offset= 0x02D8 (728) ] */
  0x00, 0x00, 0x00, 0xF8, 0x84, 0x84, 0xF8, 0x90,
  0x88, 0x88, 0x84, 0x00, 0x00, 0x00,

/* character 0x0053 ('S'): [width=7, offset= 0x02E6 (742) ] */
  0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x60, 0x18,
  0x04, 0x84, 0x78, 0x00, 0x00, 0x00,

/* character 0x0054 ('T'): [width=6, offset= 0x02F4 (756) ] */
  0x00, 0x00, 0x00, 0xF8, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x00, 0x00, 0x00,

/* character 0x0055 ('U'): [width=7, offset= 0x0302 (770) ] */
  0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84,
  0x84, 0x84, 0x78, 0x00, 0x00, 0x00,

/* character 0x0056 ('V'): [width=8, offset= 0x0310 (784) ] */
  0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28,
  0x28, 0x10, 0x10, 0x00, 0x00, 0x00,

/* character 0x0057 ('W'): [width=11, offset= 0x031E (798) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x20,
  0x8A, 0x20, 0x4A, 0x40, 0x4A, 0x40, 0x51, 0x40,
  0x51, 0x40, 0x20, 0x80, 0x20, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,

/* character 0x0058 ('X'): [width=7, offset= 0x033A (826) ] */
  0x00, 0x00, 0x00, 0x84, 0x48, 0x48, 0x30, 0x30,
  0x48, 0x48, 0x84, 0x00, 0x00, 0x00,

/* character 0x0059 ('Y'): [width=8, offset= 0x0348 (840) ] */
  0x00, 0x00, 0x00, 0x82, 0x44, 0x44, 0x28, 0x10,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00,

/* character 0x005A ('Z'): [width=7, offset= 0x0356 (854) ] */
  0x00, 0x00, 0x00, 0x7C, 0x08, 0x10, 0x10, 0x20,
  0x20, 0x40, 0xFC, 0x00, 0x00, 0x00,

/* character 0x005B ('['): [width=3, offset= 0x0364 (868) ] */
  0x00, 0x00, 0x00, 0xC0, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0xC0, 0x00,

/* character 0x005C ('\'): [width=3, offset= 0x0372 (882) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x40,
  0x40, 0x20, 0x20, 0x00, 0x00, 0x00,

/* character 0x005D (']'): [width=3, offset= 0x0380 (896) ] */
  0x00, 0x00, 0x00, 0xC0, 0x40, 0x40, 0x40, 0x40,
  0x40, 0x40, 0x40, 0x40, 0xC0, 0x00,

/* character 0x005E ('^'): [width=5, offset= 0x038E (910) ] */
  0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x88, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x005F ('_'): [width=6, offset= 0x039C (924) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFC, 0x00,

/* character 0x0060 ('`'): [width=4, offset= 0x03AA (938) ] */
  0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x0061 ('a'): [width=6, offset= 0x03B8 (952) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x78,
  0x88, 0x98, 0x68, 0x00, 0x00, 0x00,

/* character 0x0062 ('b'): [width=6, offset= 0x03C6 (966) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0xB0, 0xC8, 0x88,
  0x88, 0xC8, 0xB0, 0x00, 0x00, 0x00,

/* character 0x0063 ('c'): [width=6, offset= 0x03D4 (980) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x80,
  0x80, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0064 ('d'): [width=6, offset= 0x03E2 (994) ] */
  0x00, 0x00, 0x00, 0x08, 0x08, 0x68, 0x98, 0x88,
  0x88, 0x98, 0x68, 0x00, 0x00, 0x00,

/* character 0x0065 ('e'): [width=6, offset= 0x03F0 (1008) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0xF8,
  0x80, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0066 ('f'): [width=4, offset= 0x03FE (1022) ] */
  0x00, 0x00, 0x00, 0x20, 0x40, 0xE0, 0x40, 0x40,
  0x40, 0x40, 0x40, 0x00, 0x00, 0x00,

/* character 0x0067 ('g'): [width=6, offset= 0x040C (1036) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x98, 0x88,
  0x88, 0x98, 0x68, 0x08, 0xF0, 0x00,

/* character 0x0068 ('h'): [width=6, offset= 0x041A (1050) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0xB0, 0xC8, 0x88,
  0x88, 0x88, 0x88, 0x00, 0x00, 0x00,

/* character 0x0069 ('i'): [width=2, offset= 0x0428 (1064) ] */
  0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x006A ('j'): [width=2, offset= 0x0436 (1078) ] */
  0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x00, 0x00,

/* character 0x006B ('k'): [width=5, offset= 0x0444 (1092) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x90, 0xA0, 0xC0,
  0xA0, 0xA0, 0x90, 0x00, 0x00, 0x00,

/* character 0x006C ('l'): [width=2, offset= 0x0452 (1106) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x006D ('m'): [width=8, offset= 0x0460 (1120) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xBC, 0xD2, 0x92,
  0x92, 0x92, 0x92, 0x00, 0x00, 0x00,

/* character 0x006E ('n'): [width=6, offset= 0x046E (1134) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x88, 0x88,
  0x88, 0x88, 0x88, 0x00, 0x00, 0x00,

/* character 0x006F ('o'): [width=6, offset= 0x047C (1148) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88,
  0x88, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0070 ('p'): [width=6, offset= 0x048A (1162) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xC8, 0x88,
  0x88, 0xC8, 0xB0, 0x80, 0x80, 0x00,

/* character 0x0071 ('q'): [width=6, offset= 0x0498 (1176) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x98, 0x88,
  0x88, 0x98, 0x68, 0x08, 0x08, 0x00,

/* character 0x0072 ('r'): [width=4, offset= 0x04A6 (1190) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xC0, 0x80,
  0x80, 0x80, 0x80, 0x00, 0x00, 0x00,

/* character 0x0073 ('s'): [width=6, offset= 0x04B4 (1204) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x60,
  0x10, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x0074 ('t'): [width=3, offset= 0x04C2 (1218) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0x80, 0x80,
  0x80, 0x80, 0xC0, 0x00, 0x00, 0x00,

/* character 0x0075 ('u'): [width=6, offset= 0x04D0 (1232) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88,
  0x88, 0x98, 0x68, 0x00, 0x00, 0x00,

/* character 0x0076 ('v'): [width=6, offset= 0x04DE (1246) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x50,
  0x50, 0x20, 0x20, 0x00, 0x00, 0x00,

/* character 0x0077 ('w'): [width=10, offset= 0x04EC (1260) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x88, 0x80, 0x94, 0x80, 0x55, 0x00,
  0x55, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,

/* character 0x0078 ('x'): [width=6, offset= 0x0508 (1288) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x50, 0x20,
  0x20, 0x50, 0x88, 0x00, 0x00, 0x00,

/* character 0x0079 ('y'): [width=6, offset= 0x0516 (1302) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x50,
  0x50, 0x20, 0x20, 0x20, 0x40, 0x00,

/* character 0x007A ('z'): [width=6, offset= 0x0524 (1316) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x10, 0x20,
  0x20, 0x40, 0xF8, 0x00, 0x00, 0x00,

/* character 0x007B ('{'): [width=4, offset= 0x0532 (1330) ] */
  0x00, 0x00, 0x00, 0x20, 0x40, 0x40, 0x40, 0x80,
  0x40, 0x40, 0x40, 0x40, 0x20, 0x00,

/* character 0x007C ('|'): [width=2, offset= 0x0540 (1344) ] */
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x00,

/* character 0x007D ('}'): [width=4, offset= 0x054E (1358) ] */
  0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x20, 0x10,
  0x20, 0x20, 0x20, 0x20, 0x40, 0x00,

/* character 0x007E ('~'): [width=6, offset= 0x055C (1372) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x007F (''): [width=8, offset= 0x056A (1386) ] */
  0x00, 0x00, 0x00, 0xE0, 0xA0, 0xA0, 0xA0, 0xA0,
  0xA0, 0xA0, 0xE0, 0x00, 0x00, 0x00,

/* character 0x00A2 ('¢'): [width=6, offset= 0x0578 (1400) ] */
  0x00, 0x00, 0x00, 0x10, 0x10, 0x70, 0xA8, 0xA0,
  0xA0, 0xA8, 0x70, 0x40, 0x40, 0x00,

/* character 0x00A3 ('£'): [width=6, offset= 0x0586 (1414) ] */
  0x00, 0x00, 0x00, 0x30, 0x48, 0x40, 0x40, 0xE0,
  0x40, 0x60, 0x98, 0x00, 0x00, 0x00,

/* character 0x00A5 ('¥'): [width=6, offset= 0x0594 (1428) ] */
  0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0xF8,
  0x20, 0xF8, 0x20, 0x00, 0x00, 0x00,

/* character 0x00A7 ('§'): [width=6, offset= 0x05A2 (1442) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x40, 0xE0, 0x90,
  0x48, 0x28, 0x10, 0x88, 0x70, 0x00,

/* character 0x00A9 ('©'): [width=8, offset= 0x05B0 (1456) ] */
  0x00, 0x00, 0x00, 0x3C, 0x42, 0x9D, 0xA1, 0xA5,
  0x99, 0x42, 0x3C, 0x00, 0x00, 0x00,

/* character 0x00AC ('¬'): [width=6, offset= 0x05BE (1470) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x08,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x00AE ('®'): [width=8, offset= 0x05CC (1484) ] */
  0x00, 0x00, 0x00, 0x3C, 0x42, 0xB9, 0xA5, 0xB9,
  0xA5, 0x42, 0x3C, 0x00, 0x00, 0x00,

/* character 0x00B0 ('°'): [width=4, offset= 0x05DA (1498) ] */
  0x00, 0x00, 0x00, 0xE0, 0xA0, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x00B1 ('±'): [width=6, offset= 0x05E8 (1512) ] */
  0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xF8, 0x20,
  0x20, 0x00, 0xF8, 0x00, 0x00, 0x00,

/* character 0x00B2 ('²'): [width=4, offset= 0x05F6 (1526) ] */
  0x00, 0x00, 0x00, 0xE0, 0x20, 0x40, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x00B3 ('³'): [width=4, offset= 0x0604 (1540) ] */
  0x00, 0x00, 0x00, 0xE0, 0x40, 0x20, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x00B5 ('µ'): [width=6, offset= 0x0612 (1554) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88,
  0x88, 0x88, 0xF8, 0x80, 0x80, 0x00,

/* character 0x00B9 ('¹'): [width=4, offset= 0x0620 (1568) ] */
  0x00, 0x00, 0x00, 0x20, 0x60, 0x20, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x00BA ('º'): [width=5, offset= 0x062E (1582) ] */
  0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

/* character 0x00C4 ('Ä'): [width=8, offset= 0x063C (1596) ] */
  0x00, 0x28, 0x00, 0x10, 0x28, 0x28, 0x28, 0x44,
  0x7C, 0x82, 0x82, 0x00, 0x00, 0x00,

/* character 0x00D6 ('Ö'): [width=8, offset= 0x064A (1610) ] */
  0x00, 0x28, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82,
  0x82, 0x44, 0x38, 0x00, 0x00, 0x00,

/* character 0x00DC ('Ü'): [width=7, offset= 0x0658 (1624) ] */
  0x00, 0x28, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84,
  0x84, 0x84, 0x78, 0x00, 0x00, 0x00,

/* character 0x00DF ('ß'): [width=7, offset= 0x0666 (1638) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x90, 0x98,
  0x84, 0xA4, 0x98, 0x00, 0x00, 0x00,

/* character 0x00E4 ('ä'): [width=6, offset= 0x0674 (1652) ] */
  0x00, 0x00, 0x00, 0x50, 0x00, 0x70, 0x88, 0x78,
  0x88, 0x98, 0x68, 0x00, 0x00, 0x00,

/* character 0x00F6 ('ö'): [width=6, offset= 0x0682 (1666) ] */
  0x00, 0x00, 0x00, 0x50, 0x00, 0x70, 0x88, 0x88,
  0x88, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x00FC ('ü'): [width=6, offset= 0x0690 (1680) ] */
  0x00, 0x00, 0x00, 0x50, 0x00, 0x88, 0x88, 0x88,
  0x88, 0x98, 0x68, 0x00, 0x00, 0x00,

/* character 0x0394 ('?'): [width=8, offset= 0x069E (1694) ] */
  0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x44,
  0x44, 0x82, 0xFE, 0x00, 0x00, 0x00,

/* character 0x039B ('?'): [width=8, offset= 0x06AC (1708) ] */
  0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x44,
  0x44, 0x82, 0x82, 0x00, 0x00, 0x00,

/* character 0x03A9 ('O'): [width=8, offset= 0x06BA (1722) ] */
  0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82,
  0x82, 0x44, 0xC6, 0x00, 0x00, 0x00,

/* character 0x03B5 ('e'): [width=5, offset= 0x06C8 (1736) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x80, 0x60,
  0x80, 0x80, 0x70, 0x00, 0x00, 0x00,

/* character 0x03B8 ('?'): [width=6, offset= 0x06D6 (1750) ] */
  0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0xF8, 0x88,
  0x88, 0x88, 0x70, 0x00, 0x00, 0x00,

/* character 0x03BC ('µ'): [width=6, offset= 0x06E4 (1764) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88,
  0x88, 0x88, 0xF8, 0x80, 0x80, 0x00,

/* character 0x03C0 ('p'): [width=9, offset= 0x06F2 (1778) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x24, 0x00, 0x24, 0x00,
  0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,

/* character 0x263A ('?'): [width=11, offset= 0x070E (1806) ] */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x30, 0x80, 0x28, 0x80,
  0x20, 0x80, 0x28, 0x80, 0x17, 0x00, 0x0E, 0x00,
  0x00, 0x00, 0x00, 0x00,

/* character 0x2640 ('?'): [width=8, offset= 0x072A (1834) ] */
  0x00, 0x00, 0x00, 0x3C, 0x42, 0x42, 0x42, 0x44,
  0x38, 0x10, 0x10, 0x3C, 0x00, 0x00,

/* character 0x2642 ('?'): [width=8, offset= 0x0738 (1848) ] */
  0x00, 0x00, 0x02, 0x0E, 0x06, 0x0A, 0x08, 0x78,
  0x44, 0x44, 0x44, 0x78, 0x00, 0x00,

/* character 0x266B ('?'): [width=8, offset= 0x0746 (1862) ] */
  0x00, 0x00, 0x00, 0x06, 0x1E, 0x22, 0x22, 0x22,
  0x26, 0x6E, 0xE4, 0x60, 0x00, 0x00,

};

/*******************************************************************************************
   Offset table provides the starting offset of each character in the data table.

   If you can calculate the offsets by yourself, undefine USE_OFFSET_TABLE.

   Offset table provides the starting offset of each character in the data table.

   To get the starting offset of character 'A', you can use the following expression:

     const USHORT index = GetIndex('A');
     const ULONG offset = offset_table[index];

*******************************************************************************************/
const unsigned int fontArial14h_offset_tablep[] PROGMEM =
{
/*  offset      offsetHex  -  char    hexcode    decimal */
/*  =======     =========  -  ====    =======    ======= */
  0,         /*         0  -          0020       32      */
  14,        /*         E  -  !       0021       33      */
  28,        /*        1C  -  "       0022       34      */
  42,        /*        2A  -  #       0023       35      */
  56,        /*        38  -  $       0024       36      */
  70,        /*        46  -  %       0025       37      */
  98,        /*        62  -  &       0026       38      */
  112,       /*        70  -  '       0027       39      */
  126,       /*        7E  -  (       0028       40      */
  140,       /*        8C  -  )       0029       41      */
  154,       /*        9A  -  *       002A       42      */
  168,       /*        A8  -  +       002B       43      */
  182,       /*        B6  -  ,       002C       44      */
  196,       /*        C4  -  -       002D       45      */
  210,       /*        D2  -  .       002E       46      */
  224,       /*        E0  -  /       002F       47      */
  238,       /*        EE  -  0       0030       48      */
  252,       /*        FC  -  1       0031       49      */
  266,       /*       10A  -  2       0032       50      */
  280,       /*       118  -  3       0033       51      */
  294,       /*       126  -  4       0034       52      */
  308,       /*       134  -  5       0035       53      */
  322,       /*       142  -  6       0036       54      */
  336,       /*       150  -  7       0037       55      */
  350,       /*       15E  -  8       0038       56      */
  364,       /*       16C  -  9       0039       57      */
  378,       /*       17A  -  :       003A       58      */
  392,       /*       188  -  ;       003B       59      */
  406,       /*       196  -  <       003C       60      */
  420,       /*       1A4  -  =       003D       61      */
  434,       /*       1B2  -  >       003E       62      */
  448,       /*       1C0  -  ?       003F       63      */
  462,       /*       1CE  -  @       0040       64      */
  490,       /*       1EA  -  A       0041       65      */
  504,       /*       1F8  -  B       0042       66      */
  518,       /*       206  -  C       0043       67      */
  532,       /*       214  -  D       0044       68      */
  546,       /*       222  -  E       0045       69      */
  560,       /*       230  -  F       0046       70      */
  574,       /*       23E  -  G       0047       71      */
  588,       /*       24C  -  H       0048       72      */
  602,       /*       25A  -  I       0049       73      */
  616,       /*       268  -  J       004A       74      */
  630,       /*       276  -  K       004B       75      */
  644,       /*       284  -  L       004C       76      */
  658,       /*       292  -  M       004D       77      */
  672,       /*       2A0  -  N       004E       78      */
  686,       /*       2AE  -  O       004F       79      */
  700,       /*       2BC  -  P       0050       80      */
  714,       /*       2CA  -  Q       0051       81      */
  728,       /*       2D8  -  R       0052       82      */
  742,       /*       2E6  -  S       0053       83      */
  756,       /*       2F4  -  T       0054       84      */
  770,       /*       302  -  U       0055       85      */
  784,       /*       310  -  V       0056       86      */
  798,       /*       31E  -  W       0057       87      */
  826,       /*       33A  -  X       0058       88      */
  840,       /*       348  -  Y       0059       89      */
  854,       /*       356  -  Z       005A       90      */
  868,       /*       364  -  [       005B       91      */
  882,       /*       372  -  \       005C       92      */
  896,       /*       380  -  ]       005D       93      */
  910,       /*       38E  -  ^       005E       94      */
  924,       /*       39C  -  _       005F       95      */
  938,       /*       3AA  -  `       0060       96      */
  952,       /*       3B8  -  a       0061       97      */
  966,       /*       3C6  -  b       0062       98      */
  980,       /*       3D4  -  c       0063       99      */
  994,       /*       3E2  -  d       0064       100     */
  1008,      /*       3F0  -  e       0065       101     */
  1022,      /*       3FE  -  f       0066       102     */
  1036,      /*       40C  -  g       0067       103     */
  1050,      /*       41A  -  h       0068       104     */
  1064,      /*       428  -  i       0069       105     */
  1078,      /*       436  -  j       006A       106     */
  1092,      /*       444  -  k       006B       107     */
  1106,      /*       452  -  l       006C       108     */
  1120,      /*       460  -  m       006D       109     */
  1134,      /*       46E  -  n       006E       110     */
  1148,      /*       47C  -  o       006F       111     */
  1162,      /*       48A  -  p       0070       112     */
  1176,      /*       498  -  q       0071       113     */
  1190,      /*       4A6  -  r       0072       114     */
  1204,      /*       4B4  -  s       0073       115     */
  1218,      /*       4C2  -  t       0074       116     */
  1232,      /*       4D0  -  u       0075       117     */
  1246,      /*       4DE  -  v       0076       118     */
  1260,      /*       4EC  -  w       0077       119     */
  1288,      /*       508  -  x       0078       120     */
  1302,      /*       516  -  y       0079       121     */
  1316,      /*       524  -  z       007A       122     */
  1330,      /*       532  -  {       007B       123     */
  1344,      /*       540  -  |       007C       124     */
  1358,      /*       54E  -  }       007D       125     */
  1372,      /*       55C  -  ~       007E       126     */
  1386,      /*       56A  -         007F       127     */
  1400,      /*       578  -  ¢       00A2       162     */
  1414,      /*       586  -  £       00A3       163     */
  1428,      /*       594  -  ¥       00A5       165     */
  1442,      /*       5A2  -  §       00A7       167     */
  1456,      /*       5B0  -  ©       00A9       169     */
  1470,      /*       5BE  -  ¬       00AC       172     */
  1484,      /*       5CC  -  ®       00AE       174     */
  1498,      /*       5DA  -  °       00B0       176     */
  1512,      /*       5E8  -  ±       00B1       177     */
  1526,      /*       5F6  -  ²       00B2       178     */
  1540,      /*       604  -  ³       00B3       179     */
  1554,      /*       612  -  µ       00B5       181     */
  1568,      /*       620  -  ¹       00B9       185     */
  1582,      /*       62E  -  º       00BA       186     */
  1596,      /*       63C  -  Ä       00C4       196     */
  1610,      /*       64A  -  Ö       00D6       214     */
  1624,      /*       658  -  Ü       00DC       220     */
  1638,      /*       666  -  ß       00DF       223     */
  1652,      /*       674  -  ä       00E4       228     */
  1666,      /*       682  -  ö       00F6       246     */
  1680,      /*       690  -  ü       00FC       252     */
  1694,      /*       69E  -  ?       0394       916     */
  1708,      /*       6AC  -  ?       039B       923     */
  1722,      /*       6BA  -  O       03A9       937     */
  1736,      /*       6C8  -  e       03B5       949     */
  1750,      /*       6D6  -  ?       03B8       952     */
  1764,      /*       6E4  -  µ       03BC       956     */
  1778,      /*       6F2  -  p       03C0       960     */
  1806,      /*       70E  -  ?       263A       9786    */
  1834,      /*       72A  -  ?       2640       9792    */
  1848,      /*       738  -  ?       2642       9794    */
  1862,      /*       746  -  ?       266B       9835    */

  1876,      /*       754  -  extra address: the end of the last character's imagebits data */
};

/*******************************************************************************************
   Width table provides the width of each character. It's useful for proportional font.
   For monospaced font, the widths of all character are the same.

   Generally speaking, the width table is not needed for monospaced font. you can get
   the width from the font header.

   If you do not need the width table, undefine USE_WIDTH_TABLE.

   To get the width of character 'A', you can use the following expression:

     const USHORT index = GetIndex('A');
     const USHORT width = width_table[index];

*******************************************************************************************/
const unsigned short fontArial14h_width_tablep[] PROGMEM =
{
/*  width    char    hexcode    decimal */
/*  =====    ====    =======    ======= */
  3,       /*          0020        32   */
  2,       /*  !       0021        33   */
  4,       /*  "       0022        34   */
  6,       /*  #       0023        35   */
  6,       /*  $       0024        36   */
  10,      /*  %       0025        37   */
  7,       /*  &       0026        38   */
  2,       /*  '       0027        39   */
  4,       /*  (       0028        40   */
  4,       /*  )       0029        41   */
  4,       /*  *       002A        42   */
  6,       /*  +       002B        43   */
  3,       /*  ,       002C        44   */
  4,       /*  -       002D        45   */
  3,       /*  .       002E        46   */
  3,       /*  /       002F        47   */
  6,       /*  0       0030        48   */
  6,       /*  1       0031        49   */
  6,       /*  2       0032        50   */
  6,       /*  3       0033        51   */
  6,       /*  4       0034        52   */
  6,       /*  5       0035        53   */
  6,       /*  6       0036        54   */
  6,       /*  7       0037        55   */
  6,       /*  8       0038        56   */
  6,       /*  9       0039        57   */
  3,       /*  :       003A        58   */
  3,       /*  ;       003B        59   */
  6,       /*  <       003C        60   */
  6,       /*  =       003D        61   */
  6,       /*  >       003E        62   */
  6,       /*  ?       003F        63   */
  11,      /*  @       0040        64   */
  8,       /*  A       0041        65   */
  7,       /*  B       0042        66   */
  7,       /*  C       0043        67   */
  7,       /*  D       0044        68   */
  6,       /*  E       0045        69   */
  6,       /*  F       0046        70   */
  8,       /*  G       0047        71   */
  7,       /*  H       0048        72   */
  2,       /*  I       0049        73   */
  5,       /*  J       004A        74   */
  7,       /*  K       004B        75   */
  6,       /*  L       004C        76   */
  8,       /*  M       004D        77   */
  7,       /*  N       004E        78   */
  8,       /*  O       004F        79   */
  6,       /*  P       0050        80   */
  8,       /*  Q       0051        81   */
  7,       /*  R       0052        82   */
  7,       /*  S       0053        83   */
  6,       /*  T       0054        84   */
  7,       /*  U       0055        85   */
  8,       /*  V       0056        86   */
  11,      /*  W       0057        87   */
  7,       /*  X       0058        88   */
  8,       /*  Y       0059        89   */
  7,       /*  Z       005A        90   */
  3,       /*  [       005B        91   */
  3,       /*  \       005C        92   */
  3,       /*  ]       005D        93   */
  5,       /*  ^       005E        94   */
  6,       /*  _       005F        95   */
  4,       /*  `       0060        96   */
  6,       /*  a       0061        97   */
  6,       /*  b       0062        98   */
  6,       /*  c       0063        99   */
  6,       /*  d       0064       100   */
  6,       /*  e       0065       101   */
  4,       /*  f       0066       102   */
  6,       /*  g       0067       103   */
  6,       /*  h       0068       104   */
  2,       /*  i       0069       105   */
  2,       /*  j       006A       106   */
  5,       /*  k       006B       107   */
  2,       /*  l       006C       108   */
  8,       /*  m       006D       109   */
  6,       /*  n       006E       110   */
  6,       /*  o       006F       111   */
  6,       /*  p       0070       112   */
  6,       /*  q       0071       113   */
  4,       /*  r       0072       114   */
  6,       /*  s       0073       115   */
  3,       /*  t       0074       116   */
  6,       /*  u       0075       117   */
  6,       /*  v       0076       118   */
  10,      /*  w       0077       119   */
  6,       /*  x       0078       120   */
  6,       /*  y       0079       121   */
  6,       /*  z       007A       122   */
  4,       /*  {       007B       123   */
  2,       /*  |       007C       124   */
  4,       /*  }       007D       125   */
  6,       /*  ~       007E       126   */
  8,       /*         007F       127   */
  6,       /*  ¢       00A2       162   */
  6,       /*  £       00A3       163   */
  6,       /*  ¥       00A5       165   */
  6,       /*  §       00A7       167   */
  8,       /*  ©       00A9       169   */
  6,       /*  ¬       00AC       172   */
  8,       /*  ®       00AE       174   */
  4,       /*  °       00B0       176   */
  6,       /*  ±       00B1       177   */
  4,       /*  ²       00B2       178   */
  4,       /*  ³       00B3       179   */
  6,       /*  µ       00B5       181   */
  4,       /*  ¹       00B9       185   */
  5,       /*  º       00BA       186   */
  8,       /*  Ä       00C4       196   */
  8,       /*  Ö       00D6       214   */
  7,       /*  Ü       00DC       220   */
  7,       /*  ß       00DF       223   */
  6,       /*  ä       00E4       228   */
  6,       /*  ö       00F6       246   */
  6,       /*  ü       00FC       252   */
  8,       /*  ?       0394       916   */
  8,       /*  ?       039B       923   */
  8,       /*  O       03A9       937   */
  5,       /*  e       03B5       949   */
  6,       /*  ?       03B8       952   */
  6,       /*  µ       03BC       956   */
  9,       /*  p       03C0       960   */
  11,      /*  ?       263A      9786   */
  8,       /*  ?       2640      9792   */
  8,       /*  ?       2642      9794   */
  8,       /*  ?       266B      9835   */
};


#define LCDWIDTH 64
#define LCDHEIGHT 48
#define LCDSIZE (LCDWIDTH * LCDHEIGHT)  // In PIXEL !!! muss durch 32 teilbar sein fuer longs.
unsigned char lcdbuffer[LCDSIZE/8];


void i2c_oled_write_command(unsigned char i2cbaseadr, unsigned char cmdvalue)
{
  
  Wire.beginTransmission(i2cbaseadr);
  Wire.write(0x80); // 1000 0000 co=1 DC =0  ist commando oder parameter fuer letztes kommando
  Wire.write(cmdvalue);
  Wire.endTransmission();
}



void i2c_oled_entire_onoff(unsigned char i2cbaseadr, unsigned char onoff)
{
  if (onoff == 1) { // anschalten alle PIXEL EIN
    i2c_oled_write_command(i2cbaseadr,0xA5); 
  } else { // Daten aus dem RAM
    i2c_oled_write_command(i2cbaseadr,0xA4); 
  }
}


void i2c_oled_display_onoff(unsigned char i2cbaseadr, unsigned char onoff)
{
  if (onoff == 1) { // anschalten display 
    i2c_oled_write_command(i2cbaseadr,0xAF); 
  } else { // ausschalten display
    i2c_oled_write_command(i2cbaseadr,0xAE); 
  }
}

void i2c_oled_setbrightness(unsigned char i2cbaseadr, unsigned char wert)
{
  i2c_oled_write_command(i2cbaseadr,0x81); // cmd fuer brightness
  i2c_oled_write_command(i2cbaseadr,wert); // 2. wert dann brightness
}


void i2c_oled_inverse_onoff(unsigned char i2cbaseadr, unsigned char onoff)
{
  if (onoff == 1) { // inverse
    i2c_oled_write_command(i2cbaseadr,0xA7); 
  } else { // ausschalten display
    i2c_oled_write_command(i2cbaseadr,0xA6); 
  }
}

// INIT 64x48 display:


void i2c_oled_initall(unsigned char i2cbaseadr)
{
  // i2c_oled_display_onff(i2cbaseadr,0); // ERST mal aus.
  i2c_oled_write_command(i2cbaseadr,0xAE);   // display off 
  //
  i2c_oled_write_command(i2cbaseadr,0x00); /*set lower column address*/
 i2c_oled_write_command(i2cbaseadr,0x12); /*set higher column address*/  
 i2c_oled_write_command(i2cbaseadr,0x40); /*set display start line*/
 i2c_oled_write_command(i2cbaseadr,0xB0); /*set page address*/
 i2c_oled_write_command(i2cbaseadr,0x81); /*contract control*/
 i2c_oled_write_command(i2cbaseadr,0xff); /*128*/
 i2c_oled_write_command(i2cbaseadr,0xA1); /*set segment remap*/
 i2c_oled_write_command(i2cbaseadr,0xA6); /*normal / reverse*/
 i2c_oled_write_command(i2cbaseadr,0xA8); /*multiplex ratio*/
 i2c_oled_write_command(i2cbaseadr,0x2F); /*duty = 1/48*/
 i2c_oled_write_command(i2cbaseadr,0xC8); /*Com scan direction*/
 i2c_oled_write_command(i2cbaseadr,0xD3); /*set display offset*/
 i2c_oled_write_command(i2cbaseadr,0x00);
 i2c_oled_write_command(i2cbaseadr,0xD5); /*set osc division*/
 i2c_oled_write_command(i2cbaseadr,0x80);
 i2c_oled_write_command(i2cbaseadr,0xD9); /*set pre-charge period*/
 i2c_oled_write_command(i2cbaseadr,0x21);
 i2c_oled_write_command(i2cbaseadr,0xDA); /*set COM pins*/
 i2c_oled_write_command(i2cbaseadr,0x12);
 i2c_oled_write_command(i2cbaseadr,0xdb); /*set vcomh*/
 i2c_oled_write_command(i2cbaseadr,0x40);
 i2c_oled_write_command(i2cbaseadr,0x8d); /*set charge pump enable*/
 i2c_oled_write_command(i2cbaseadr,0x14);
 i2c_oled_write_command(i2cbaseadr,0xAF);   // enable display
  //
}

void i2c_oled_initalllarge(unsigned char i2cbaseadr)
{
  // i2c_oled_display_onff(i2cbaseadr,0); // ERST mal aus.
  i2c_oled_write_command(i2cbaseadr,0xd5); // divide ratio osc freq 
  i2c_oled_write_command(i2cbaseadr,0x80); // f0 flackert werniger als 80
  //
  i2c_oled_write_command(i2cbaseadr,0xa8); // multiplex ratio mode:63
  i2c_oled_write_command(i2cbaseadr,0x3f);
  //
  i2c_oled_write_command(i2cbaseadr,0xd3); // set display offset
  i2c_oled_write_command(i2cbaseadr,0); // value 0
  //
  i2c_oled_write_command(i2cbaseadr,0x40); // set display startline (D5..D0 = line)
  //
  i2c_oled_write_command(i2cbaseadr,0x8D); // charge pump on + 14 + af
  i2c_oled_write_command(i2cbaseadr,0x14); // Enable charge pump
  // 
  i2c_oled_write_command(i2cbaseadr,0xA1); // segment remap hor richtung a1 nach links nach rechts a0 rechts nach links
  //
  i2c_oled_write_command(i2cbaseadr,0xC8); // c8 von oben nach unten c0 von unten nach oben
  //
  i2c_oled_write_command(i2cbaseadr,0xda); // common pads hardware: alternative
  //
  i2c_oled_write_command(i2cbaseadr,0x12); // 12: OK, 32: dasselbe, 02: Datenmüll
  //
  i2c_oled_write_command(i2cbaseadr,0x81); // set brightness
  i2c_oled_write_command(i2cbaseadr,0xff); // 0..ff
  // 
  i2c_oled_write_command(i2cbaseadr,0xD9);  // set precharge period
  i2c_oled_write_command(i2cbaseadr,0xF1);   // F1 flacher staerker, 11//22 weniger stark
  //
  i2c_oled_write_command(i2cbaseadr,0xDB);   // COM Deselect level
  i2c_oled_write_command(i2cbaseadr,0x40);   // 0.83*VCC laut datenblatt von legendary
  //
  i2c_oled_write_command(i2cbaseadr,0xA4);    // Display on alle pixel ein
  //
  i2c_oled_write_command(i2cbaseadr,0xA6);   // set normal display a6=normal a7=invertiert
  //
  i2c_oled_write_command(i2cbaseadr,0xAF);   // enable display
  //
}






// zeilen 0..7 
unsigned char i2c_oled_write_top(unsigned char i2cbaseadr, int zeile,
                    int bytes,  unsigned char barray[],signed int sh1106padding)
{
  int i;

  
  i2c_oled_write_command(i2cbaseadr,0x20); // page address mode
  i2c_oled_write_command(i2cbaseadr,0x02); // page address mode
  // ** 
  //
  i2c_oled_write_command(i2cbaseadr,0xb0+(zeile & 7)); // B0..B7
  //
  i2c_oled_write_command(i2cbaseadr,0x00); // $00 lower nibble col + x3x2x1x0
  i2c_oled_write_command(i2cbaseadr,0x10); // $10 high  nibble col + x3x2x1x0
  //
  // DANN Daten senden Umschalten auf Daten Modus
  // 
  
  // ACHTUNG bei Arduino anscheinend max 32 bytes data
  // Wirelib mxa 32 bytes buffer size !! 
  // daher zerlegen noetig !!
 
  // AChtung col 1..64-seg95..seg32  row 1..48 com32..com55
  
  // zahl bytes / 8 teilbar !!
  int j=0;
  int k =0;

// MAX LIMIT daher zwei schleifen bei Arduino
    
    Wire.beginTransmission(i2cbaseadr);
    Wire.write(0x40); // 0100 0000 co=0 DC =1  ist data follow no cmd repeat
    for (i=0; i<16; i++) {
       Wire.write(0);    
    }
    Wire.endTransmission();
 
    Wire.beginTransmission(i2cbaseadr);
    Wire.write(0x40); // 0100 0000 co=0 DC =1  ist data follow no cmd repeat
    for (i=0; i<16; i++) {
       Wire.write(0);    
    }
    Wire.endTransmission();
 
  
  for (k=0; k<8; k++) {
    Wire.beginTransmission(i2cbaseadr);
    Wire.write(0x40); // 0100 0000 co=0 DC =1  ist data follow no cmd repeat
    for (i=0; i<bytes/8; i++) {
       Wire.write(barray[j++]);    
    }
    Wire.endTransmission();
  }
  //
}

// ACHTUNG VERZAHNTes Display...
void disp_lcd_frombuffer() {
    // 132 fix an der Stelle !!
    // 64yx48 
    // AChtung col 1..64-seg95..seg32  row 1..48 com32..com55
    // verzahnt com 0..23 nach 48..2 und com 32..55 nach row 47..1
    // offsets im transfer std 0..8 
    i2c_oled_write_top(i2coledssd, 0, 64, &lcdbuffer[0], 0);
    i2c_oled_write_top(i2coledssd, 1, 64, &lcdbuffer[64], 0);
    i2c_oled_write_top(i2coledssd, 2, 64, &lcdbuffer[64*2], 0);
    i2c_oled_write_top(i2coledssd, 3, 64, &lcdbuffer[64*3], 0);
    i2c_oled_write_top(i2coledssd, 4, 64, &lcdbuffer[64*4], 0);
    i2c_oled_write_top(i2coledssd, 5, 64, &lcdbuffer[64*5], 0);
   
}

// Buffer loeschen mit farbe
// 0 oder ff
#define COLOR_BLACK 0
#define COLOR_WHITE 1      // sonderfall

void disp_buffer_clear(unsigned short data) {
  unsigned char  *ptr = (unsigned char*)&lcdbuffer[0];
  unsigned char datal = 0;
  if (data >0) datal = 0xffffffff; // alle an dann beim loeschen
  int i = 0;
  for (i = 0; i<LCDSIZE/8; i++) {
    *ptr++ = datal;
  }
}

// x,y
// dabei row col organisation
// 132 x 64 pixel dabei 8 pixel in y-richtung mit 0 beginnend auf einem byte
// x horizontal y vertikal

// 64 x 48 pixel !!
//
void disp_setpixel(int x, int y, unsigned short col1) {
    // COL =0 dunke =1hell
  // 1 pixel setzen (little endian)
  // col1 =0 hell =1 dunkel
  // Tabelle 8 bytes per zeile
  // eintrag 0 ist rechte pixelgruppe
  // y=0 ist unten links aber physicalisch von oben nach unten (row 7 bit 7 -> y=0)
 
  unsigned char  *dest;  // zielpointer lcdbuffer
  int yoff = 0;
  int ymod = 0;
  if (x < 0) return;  // CLIP
  if (x >= LCDWIDTH) return;  // CLIP
  if (y < 0) return;
  if (y >= LCDHEIGHT) return;
 #ifdef XXXX 
  // SPEZIELL x-achse 0..63 aber y-achse abh von gerade oder ungerader zeile
  if ((y & 1) == 0) {
    // Gerade zeilen
    ymod = y & 0x7; // bitposition 0..7
    yoff = y >> 3; // offset der rows zeilen 0..7 (y>0 !!) bit 0..2 weg

    
  } else {
    // ungerade zeilen
      
  }
 #endif
  
  // berechnen row col und byte pos.
  // y = 63 - y; // damit y=0 gedreht y=0 link oben !! 
  ymod = y & 0x7; // bitposition 0..7
  yoff = y >> 3; // offset der rows zeilen 0..7 (y>0 !!) bit 0..2 weg

  dest = &lcdbuffer[yoff * LCDWIDTH + x]; // DAMIT Byte definiert
  // nun bit 0..7 moeglichs effizienz  austauschen
  if (col1 == 0) { // bit loeschen
   *dest &= ~(1<<ymod);
  } else { // bit setzen
   *dest |= (1<<ymod);
  }
  //
}

unsigned short disp_setchar(int x, int y,  unsigned char chidx1, unsigned short color) { // breite als ergebnis fuer propschrift
  unsigned char chidx;
  chidx = chidx1;
  if (chidx <= 0x20) chidx = 0x20;
  chidx -= 0x20; // erster index
  unsigned short w = pgm_read_word_near(fontArial14h_width_tablep+chidx);
  unsigned long offset = pgm_read_word_near(fontArial14h_offset_tablep+chidx);
  int maxh = 14; // anzahl der zeilen
  int i = 0, v1 = 0, v2 = 0;
  int b1;
  //

  // breite <= 8 pixel dann ein byte >=8 dann zwei bytes (max width = 16 pixel)
  if (w <= 8) { // 1 byte max
    for (i = 0; i<14; i++) { // alle zeilen abarbeiten
      v1 = pgm_read_byte_near(fontArial14h_data_tablep+offset + i); // 1 byte pro font durchlaufen
      // alle bits durchlaufen
      for (b1 = 0; b1<w; b1++) {
        if (v1 & (1 << (7 - b1))) { // big endian bits
          disp_setpixel(x + b1, y + i, color);
        }
      } // alle bits durchlaufen
    }
  } else { // 2 byte zeichen
    for (i = 0; i<14; i++) { // alle zeilen abarbeiten
      v1 = pgm_read_byte_near(fontArial14h_data_tablep+offset + i * 2); // 1 byte pro font durchlaufen
      v2 = pgm_read_byte_near(fontArial14h_data_tablep+offset + i * 2 + 1); // 1 byte pro font durchlaufen
      // alle bits durchlaufen
      for (b1 = 0; b1<8; b1++) { // erste haelfte first
        if (v1 & (1 << (7 - b1))) { // big endian bits
          disp_setpixel(x + b1, y + i, color);
        }
      } // alle bits durchlaufen
      for (b1 = 0; b1<w; b1++) { // restl bits
        if (v2 & (1 << (7 - b1))) { // big endian bits
          disp_setpixel(x + 8 + b1, y + i, color);
        }
      } // alle bits durchlaufen
    }
  }
  return(w);
}


int disp_print_xy_lcd(int x, int y, unsigned char *text, unsigned short color, int chset) { // 0=14 1=27
  int x1;
  x1 = x;
  if (text == 0) return(x);
  
    while (*text != 0) {
      x1 = x1 + disp_setchar(x1, y,  *text++, color);
    }
  
  return(x1);
}

// Linien Zeichnen

void  disp_line_lcd(int x0, int y0, int x1, int y1, unsigned short col) {
  // disp_setpixel(x+b1,y+i,color);

  int dx, dy, sx, sy, err, e2;
  dx = (x1 - x0);
  if (dx < 0) dx = -dx;
  dy = (y1 - y0);
  if (dy < 0) dy = -dy;
  if (x0 < x1) {
    sx = 1;
  } else {
    sx = -1;
  }
  if (y0 < y1) {
    sy = 1;
  } else {
    sy = -1;
  }
  //
  err = dx - dy;
  do {
    disp_setpixel(x0, y0, col);
    if ((x0 == x1) && (y0 == y1)) return;
    e2 = 2 * err;
    if (e2 > -dy) {
      err = err - dy;
      x0 = x0 + sx;
    }
    if (e2 < dx) {
      err = err + dx;
      y0 = y0 + sy;
    }
  } while (1==1);
}

// Rechteck Zeichnen



void disp_rect_lcd(int x1, int y1, int x2, int y2, unsigned short col) {
  // disp_setpixel(x+b1,y+i,color);
  disp_line_lcd(x1, y1, x2, y1, col);
  disp_line_lcd(x1, y2, x2, y2, col);
  disp_line_lcd(x1, y1, x1, y2, col);
  disp_line_lcd(x2, y1, x2, y2, col);
}

// filled rechteck zeichnen optionaler rahmen
//
void disp_filledrect_lcd(int x1, int y1, int x2, int y2, unsigned short col) {
  // disp_setpixel(x+b1,y+i,color);
  // schnelles fill
  //
  // x1,y1 und x2,y2 swappen ggf.
  unsigned short  *dest;    // zielpointer lcdbuffer mit 8 bytes per row !! (little endian codiert)

  int x, y;
  if (x1 > x2) {
    x = x1;
    x1 = x2;
    x2 = x;
  }
  if (y1 > y2) {
    y = y1;
    y1 = y2;
    y2 = y;
  }
  if (x1 < 0) x1 = 0;  // CLIP
  if (x1 >= LCDWIDTH) x1 = LCDWIDTH - 1;  // CLIP
  if (y1< 0) y1 = 0;
  if (y1 >= LCDHEIGHT) y1 = LCDHEIGHT - 1;  // CLIP;
  // ACHTUNG rechnen row
  if (x2 < 0) x2 = 0;  // CLIP
  if (x2 >= LCDWIDTH) x2 = LCDWIDTH - 1;  // CLIP
  if (y2< 0) y2 = 0;
  if (y2 >= LCDHEIGHT) y2 = LCDHEIGHT - 1;  // CLIP;

  // noch nicht ganz effizient fuer sonderfaelle
  // koennte man in bytes zusammenfassen wenn eine ganze row betroffen ist
  // also startzeile, n*zeilen 8bit endzeilen z.b.
  // bzw drei masken berechnen dafuer...
  //
  for (y = y1; y<= y2; y++) {
    for (x = 0; x<=(x2 - x1); x++) {
      disp_setpixel(x, y, col);
    }
  }

}

// -------------------------END OLED ----------------------------------------------

// 1E=GND,1c=Open,1a=VCC AD5622  JUmper offen dann 1Ch
// 0001 1aa0
// aber nur aa=01 10 11 sind  moegliche Adressen

#define i2cdasel1 (0x1a>>1)  // ADRESSE Einstellen 1a,1c,1e 
#define i2cdasel2 (0x1c>>1)  // ADRESSE Einstellen 1a,1c,1e 
#define i2cdasel3 (0x1e>>1)  // ADRESSE Einstellen 1a,1c,1e 

void i2c_da_write_command(unsigned char i2cbaseadr, unsigned short cmdvalue)
{
  // BIt15,14=0 13,12=pd (std=0) dann 11..0 = DA Value
  cmdvalue = cmdvalue & 0xFFF; // 12 Bits valide // 0..4095 Wertebereich
  Wire.beginTransmission(i2cbaseadr); // I2C Start senden
  Wire.write((cmdvalue>>8)&0xff); //  dann MSB zuerst 
  Wire.write(cmdvalue&0xff);  // danach das LSB
  Wire.endTransmission(); // I2C beenden
}

char advalbuf[64]; // loop 

void setup() {
  Wire.begin(); // I2C Initialisierung
  i2c_oled_initall(i2coledssd);  // OLED Initialsierung
  for (int i=0; i<64; i++) advalbuf[i]=47; // Default fuer Buffer
}

void loop() {   // Schleife
 // 64x48 Pixel OLED
  static int cxx = 0; // Ringbuffer
  static int daval = 0;  // fuer Ausgabe
  int ana0 = analogRead(A0); // Einlesen A/D-Umsetzer 
  char buffer[40]; // ASCII Textbuffer
  disp_buffer_clear(COLOR_BLACK); // 
  double  p1 = (ana0*5000.0)/1023.0; 
  int y1 =0; // Y Position
  sprintf(buffer, "A0=%d.%03dV",(int)p1/1000,(int)p1%1000);
  y1 = 47 - (p1 * 30.0)/5000.0; // 5V Max -> 30 pixel
  advalbuf[cxx++] = y1; // merken 0..4xx V +-128
  if (cxx >63) cxx =0;  // Ringbuffer 0..63
  disp_print_xy_lcd(2, 0, (unsigned char *)buffer, COLOR_WHITE, 0);
  int i=0; // Spalte
  int yold  = advalbuf[(cxx+1)%64];;
  for (i=0; i<63; i++) { // ALles ausgeben
   y1 =advalbuf[(cxx+1+i)%64];
   disp_line_lcd (i, yold, i, y1, COLOR_WHITE); 
   yold = y1;
  }
  disp_lcd_frombuffer();
  // DA Umsetzer Werte ausgeben Saegezahn !
  i2c_da_write_command(i2cdasel1,daval);
  i2c_da_write_command(i2cdasel2,daval);
  i2c_da_write_command(i2cdasel3,daval);
  daval  += (4096/40); // Kennlinie auf einen Schirm
  if (daval > 4095) daval = 0;
}


